<?php 	
	add_action('init', 'project_books_init');  

	/*-- Custom Post Init Begin --*/
	function project_books_init()
	{
	  $labels = array(
		'name' => _x('Книги', 'post type general name'),
		'singular_name' => _x('Книга', 'post type singular name'),
		'add_new' => _x('Добавить новую', 'book'),
		'add_new_item' => __('Добавить новую книгу'),
		'edit_item' => __('Изменить книгу'),
		'new_item' => __('Новая книга'),
		'view_item' => __('Посмотреть книгу'),
		'search_items' => __('Искать книгу'),
		'not_found' =>  __('Ничего не найдено'),
		'not_found_in_trash' => __('Нет книг в Корзине'),
		'parent_item_colon' => '',
		'menu_name' => 'Book'

	  );

	 $args = array(
		'labels' => $labels,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'query_var' => true,
		'rewrite' => true,
		'capability_type' => 'post',
		'has_archive' => true,
		'hierarchical' => false,
		'menu_position' => null,
		'supports' => array('title','editor','author','thumbnail','excerpt','comments')
	  );
	  // The following is the main step where we register the post.
	  register_post_type('book',$args);

	  // Initialize New Taxonomy Labels
	  $labels = array(
		'name' => _x( 'Жанр', 'taxonomy general name' ),
		'singular_name' => _x( 'Жанр', 'taxonomy singular name' ),
		'search_items' =>  __( 'Искать жанр' ),
		'all_items' => __( 'Все жанры' ),
		'parent_item' => __( 'Родительский жанр' ),
		'parent_item_colon' => __( 'Родительский жанр:' ),
		'edit_item' => __( 'Изменить жанр' ),
		'update_item' => __( 'Обновить жанр' ),
		'add_new_item' => __( 'Добавить новый жанр' ),
		'new_item_name' => __( 'Имя нового жанра' ),
	  );
		// Custom taxonomy for Project Tags
		register_taxonomy('book-genre',array('book'), array(
		'hierarchical' => true,
		'labels' => $labels,
		'show_ui' => true,
		'query_var' => true,
		'rewrite' => array( 'slug' => 'book-genre' ),
	  ));

	}
	/*-- Custom Post Init Ends --*/
?>